
#ifndef _1_CRYS_ATP_TST_AESFLOW_Acceptance_h_H
#define _1_CRYS_ATP_TST_AESFLOW_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_FLOW_Defines.h"
#include "CRYS_FLOW.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 14 10:18:14 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_FLOW_Acceptance.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_AESFLOW_TestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    
    /* input interrupt id */
    DxUint32_t                  inputInterruptId;
  
    /* output interrupt id */
    DxUint32_t                  outputInterruptId;
  
    /* if the data in the buffers are in words and not bytes */ 
    DxUint32_t                  wordsBuffersOrderFlag;
  
    /* number of input buffers */
    DxUint32_t                  inputBuffersArraySize;
    
    /* flag if  endian order of the input buffers is big */
    DxUint32_t                  inputBigEndianOrderFlag;
  
    /* number of input buffers */
    DxUint32_t                  outputBuffersArraySize;
    
   
    /* flag if  endian order of the output buffers is big */
    DxUint32_t                  outputBigEndianOrderFlag;
    
    DxUint8_t 			        TST_Expected_output_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
    
    DxUint8_t                   TST_Expected_cyclicOperation_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
    
    CRYS_AES_Key_t 				TST_Key;
	CRYS_AES_KeySize_t			TST_KeySize;
	CRYS_AES_IvCounter_t		TST_IvCounter;
    CRYS_AES_OperationMode_t	TST_OperationMode;
    
} TST_AESFLOW_TestDataStruct;


/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_AESSTATIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static AES FLOW API's
 
 * Algorithm:     
 *	This function initializes AES flow with static type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes AES flow, 
 *  reads data from the output buffers and compare to expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AESSTATIC_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_AESDYNAMIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for dynamic AES FLOW API's
 
 * Algorithm:     
 *	This function initializes AES flow with dynamic type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes AES flow, 
 *  reads data from the output buffers and compare to expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AESDYNAMIC_Acceptance ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_AESDYNAMIC_AddBuffers_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for dynamic AES FLOW API's
 
 * Algorithm:     
 *	This function initializes AES flow with dynamic type and other parameters,
 *  sends interrupts that input and output buffers are ready, adds buffers to
 *  dynamic flow, finishes AES flow, 
 *  reads data from the output buffers and compare to expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AESDYNAMIC_AddBuffers_Acceptance ( void );


/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_AESSTATIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for static AES FLOW API's with additional engines.

* Algorithm:     
*  This function initializes AES flow with static type and other parameters,
*  sends interrupts that input and output buffers are ready, execute some AES operation
*  compare the result of the AES to expected, send interrupt that input and output buffers are ready
*  execute DES operation , compare result of DES to expected, finishes AES flow, 
*  execute hash operation, compare result of hash to expected,
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AESSTATIC_Acceptance_WithAdditionalEngines ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_AESDYNAMIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic AES FLOW API's with additional engines.

* Algorithm:     
*  This function initializes AES flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, execute some AES operation
*  compare the result of the AES to expected, send interrupt that input and output buffers are ready
*  execute DES operation , compare result of DES to expected, finishes AES flow, 
*  execute hash operation, compare result of hash to expected,
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AESDYNAMIC_Acceptance_WithAdditionalEngines ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_AESSTATIC_Cyclic_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic AES FLOW API's
 
 * Algorithm:     
 *	This function initializes AES flow with static type and other parameters,
 * and executes several times flow on the same input buffer
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AESSTATIC_Cyclic_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_AES_ONETEST_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name
 *  flowType           - flow type (static or dynamic)
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES FLOW API
 * Algorithm:       
 *  1. Initialize AES flow with type and other parameters
 *  2. Send interrupts that input and output buffers are ready
 *  3. Finish AES flow, read data from the output buffers and compare to expected results
 *  4. Terminate flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AES_ONETEST_Acceptance ( int              TST_index, 
                                                       char            *TST_MasterTestName,
                                                       CRYS_FLOW_Type_t flowType);
                                                       
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_AESSTATIC_ONETEST_Cyclic_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic AES FLOW API's
 
 * Algorithm:   
 * 1. Initialize AES flow with static type and other parameters 
 * 2. Init AES flow
 * 3. Send interrupts to execute cyclic flow operation 
 * 4. Finish AES flow
 * 5. Get results
 * 6. Terminate flow
 * 7. Read data from the output buffers and compare to expected result
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_AESSTATIC_ONETEST_Cyclic_Acceptance (int     TST_index, 
                                                                   char   *TST_MasterTestName);


/************************ Private Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_InitParams
 *  
 * Inputs:
 *  TST_index           - test index
 *  isNotAddBufferFlow    - indication if flow is with added buffers or not
 *  pAcceptanceTestData - input test data
 *  pFlowInfo           - output flow info, intialized from test data
 *
 * Outputs:                                 
 *
 * Description:                                                                 
 *  This function initializes parameters for FLOW operation
 * Algorithm:     
 *	This function initializes pFlowInfo struct with values from the test vector.
 ******************************************************************************/                                
void CRYS_ATP_TST_FLOW_InitParams ( int                            TST_index, 
								    DxBool_t                       isNotAddBufferFlow,
									TST_FLOW_TestCommonDataStruct *pAcceptanceTestData,
									CRYS_FLOW_Params_t            *pFlowInfo,
									CRYS_FLOW_Engine_t             flowEngineType);
									
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_InterruptUp
 *  
 * Inputs:
 *  TST_InterruptId       - interrupt id
 *
 * Outputs:                                 
 *
 * Description:                                                                 
 *  This function araise the given interrupt
 * Algorithm:  Write to the corresponding register   
 ******************************************************************************/                                
 void CRYS_ATP_TST_FLOW_SendInterrupt ( int  TST_InterruptId );	
 
 /*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_CheckAESOperation
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function checks some AES operation
* Algorithm:     
* 1. Execute some AES operation 
* 2. Compare result to expected one
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_CheckAESOperation (void);								

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_InitAESFlow
 *  
 * Inputs:
 *  TST_index          - test index
 *  flowType           - flow type
 *  TST_MasterTestName - test name
 *  TST_AESFlowId      - output AES flow id
 *  pAESFlowParamsInfo - flow params info
 *  encryptMode        - encrypt/decrypt mode
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function starts AES flow.
 *
 * Algorithm:     
 *	1. Initialize Flow info parameter.
 *  2. Init AES flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_InitAESFlow ( int                     TST_index,
                                       CRYS_FLOW_Type_t        flowType,
                                       char                   *TST_MasterTestName, 
                                       DxUint32_t             *TST_AESFlowId,
                                       CRYS_FLOW_Params_t     *pAESFlowParamsInfo,
                                       CRYS_AES_EncryptMode_t  encryptMode);
                                       
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FinishAESFlow
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_AES            - flow id
 *  TST_MasterTestName - test name
 *  blockSize          - block size for finish
 *  pAESFlowParamsInfo - flow params info
 *  encryptMode        - encrypt/decrypt mode
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function finishes AES flow and check results.
 *
 * Algorithm:     
 *	1. Finish Flow
 *  2. Get results
 *  3. Compare flow output with expected output
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FinishAESFlow ( int                    TST_index, 
                                         DxUint32_t             TST_AESFlowId, 
                                         char                  *TST_MasterTestName,
                                         DxUint32_t              blockSize,
                                         CRYS_FLOW_Params_t     *pAESFlowParamsInfo,
                                         CRYS_AES_EncryptMode_t  encryptMode );
                                         
                                                       
                                         
                                       



#ifdef __cplusplus
}
#endif

#endif

#endif
